var Webflow = Webflow || [];
Webflow.push(function () {
    var video_id = $('a#videoPlay').attr("href").split('/').pop();
    $.ajax({
        type:'GET',
        url: 'https://vimeo.com/api/v2/video/' + video_id + '.json',
        jsonp: 'callback',
        dataType: 'json',
        success: function(data){
            var thumbnail_src = data[0].thumbnail_large;
            $('#videoPlay').append('<img src="' + thumbnail_src + '"/>');
        }
    });

    $('.video-link').magnificPopup({
            type: 'iframe',
            patterns: {
                vimeo: {
                    index: 'vimeo.com/',
                    id: '/',
                    src: '//player.vimeo.com/video/%id%?autoplay=1'
                },
            },
            callbacks: {
                open: function() {
                    $('video').trigger('pause');
                },
                close: function() {
                    $('video').trigger('play');
                }
            }
    });

    $('a.open-tab').attr('target','_blank');
    
    $('#resume-submit').hide();
    
    $('.apply-button').click(function(e) {
       
       $('#resume-submit').show();
       
       $('html,body').animate({
           scrollTop: $('#resume-submit').offset().top
       }, 'slow');
    });

});